$(document).ready(function() 
{

	$(window).keydown(function(event)
	{
   	if(event.keyCode == 13) 
		{
      event.preventDefault();
      return false;
    }

	});
	
	
	
class Dashboard 
{
    
    static initChartsChartJS() 
    {
        // Configuración global de Chart.js
        Chart.defaults.color = "#818d96";
        Chart.defaults.scale.grid.color = "rgba(0,0,0,.04)";
        Chart.defaults.scale.grid.zeroLineColor = "rgba(0,0,0,.1)";
        Chart.defaults.scale.beginAtZero = true;
        Chart.defaults.elements.line.borderWidth = 2;
        Chart.defaults.elements.point.radius = 5;
        Chart.defaults.elements.point.hoverRadius = 7;
        Chart.defaults.plugins.tooltip.radius = 3;
        Chart.defaults.plugins.legend.labels.boxWidth = 12;
        
        
        
        var visitas_semanaactual;
        var promociones_actual;
        var seguimientos_actual;
        var mensual_actual;
        
        $.ajax({
            'async': false,
            'type': 'POST',
            'global': false,
            'url': "/mod/dashboard/charts.php",
            'dataType': "json",
            'data': { 'act': 'visitas_semanaactual' },
            'success': function(data) {
                visitas_semanaactual = data;
            }
        });
        
        
        $.ajax({
            'async': false,
            'type': 'POST',
            'global': false,
            'url': "/mod/dashboard/charts.php",
            'dataType': "json",
            'data': { 'act': 'promociones_actual' },
            'success': function(data) {
                promociones_actual = data;
            }
        });
        
        
        $.ajax({
            'async': false,
            'type': 'POST',
            'global': false,
            'url': "/mod/dashboard/charts.php",
            'dataType': "json",
            'data': { 'act': 'seguimientos_actual' },
            'success': function(data) {
                seguimientos_actual = data;
            }
        });
        
        $.ajax({
            'async': false,
            'type': 'POST',
            'global': false,
            'url': "/mod/dashboard/charts.php",
            'dataType': "json",
            'data': { 'act': 'mensual' },
            'success': function(data) {
                mensual_actual = data;
            }
        });
        
        console.log(mensual_actual);
        
        // Datos para los diferentes gráficos
        let visitasData = 
        {
            datasets: [{
                label: "Esta semana",
                fill: true,
                backgroundColor: "rgba(6, 101, 208, .75)",
                borderColor: "rgba(6, 101, 208, 1)",
                pointBackgroundColor: "rgba(6, 101, 208, 1)",
                pointBorderColor: "#fff",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(6, 101, 208, 1)",
                data: visitas_semanaactual.actual
            }]
        };


        // Obtener elementos del DOM para los gráficos
        let visitas = document.getElementById("visitas");

        // Inicializar gráficos si los elementos existen
        if (visitas !== null) 
        {
            new Chart(visitas, { type: "line", data: visitasData, options: { tension: 0.4 } });
        }
        
        
        // Datos para los diferentes gráficos
        let promocionesData = 
        {
            datasets: [{
                label: "Esta semana",
                fill: true,
                backgroundColor: "rgba(6, 101, 208, .75)",
                borderColor: "rgba(6, 101, 208, 1)",
                pointBackgroundColor: "rgba(6, 101, 208, 1)",
                pointBorderColor: "#fff",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(6, 101, 208, 1)",
                data: promociones_actual.actual
            }]
        };


        // Obtener elementos del DOM para los gráficos
        let promociones = document.getElementById("promociones");

        // Inicializar gráficos si los elementos existen
        if (promociones !== null) 
        {
            new Chart(promociones, { type: "line", data: promocionesData, options: { tension: 0.4 } });
        }
                      
        // Datos para los diferentes gráficos
        let seguimientosData = 
        {
            datasets: [{
                label: "Esta semana",
                fill: true,
                backgroundColor: "rgba(6, 101, 208, .75)",
                borderColor: "rgba(6, 101, 208, 1)",
                pointBackgroundColor: "rgba(6, 101, 208, 1)",
                pointBorderColor: "#fff",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(6, 101, 208, 1)",
                data: seguimientos_actual.actual
            }]
        };


        // Obtener elementos del DOM para los gráficos
        let seguimientos = document.getElementById("seguimientos");

        // Inicializar gráficos si los elementos existen
        if (seguimientos !== null) 
        {
            new Chart(seguimientos, { type: "line", data: seguimientosData, options: { tension: 0.4 } });
        }
         // Datos para los diferentes gráficos
        let mensualData = 
        {
            datasets: [{
                label: "Esta Mes",
                fill: true,
                backgroundColor: "rgba(6, 101, 208, .75)",
                borderColor: "rgba(6, 101, 208, 1)",
                pointBackgroundColor: "rgba(6, 101, 208, 1)",
                pointBorderColor: "#fff",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(6, 101, 208, 1)",
                data: mensual_actual.visitas_mensuales
            }]
        };


        // Obtener elementos del DOM para los gráficos
        let mensual = document.getElementById("mensual");

        // Inicializar gráficos si los elementos existen
        if (mensual !== null) 
        {
            new Chart(mensual, { type: "line", data: mensualData, options: { tension: 0.4 } });
        }
               
    }

    static init() 
    {
        // Inicializar gráficos y eventos al cargar la página
        this.initChartsChartJS();
    }
    
}

// Inicializar Dashboard
Dashboard.init();


	var intervalo = setInterval(
	function()
	{
		$.post("/mod/restaurantes_mesas/sql.php", {act: 'mesero'},
		function(data)
		{
			if(data.resultado=='ok')
			{

    			var audioElement = document.createElement('audio');
    			audioElement.setAttribute('src', 'https://www.soundjay.com/misc/sounds/bulb-horn-02.mp3');
    			audioElement.addEventListener('ended', function() {
        			this.play();
    			}, false);
		        audioElement.addEventListener("timeupdate",function(){});

        		audioElement.play();

				var titulo	=	data.mesa+' |  Necesita atencion.';

				clearInterval(intervalo);
				Swal.fire(
				{
				  	title: titulo,
  					text: data.descripcion,
					icon: 'question',
					iconHtml: '?',				  
				  	showDenyButton: true,
				  	confirmButtonText: '¡En camino!',
				  	denyButtonText: 'No atender',

				})
				.then((result) => 
				{

				  if (result.isConfirmed) 
				  {
        			
        			audioElement.pause();
        			audioElement.currentTime = 0;
        			mesero(data.r_id, data.rm_id,'1');
				  } 
				  else if (result.isDenied) 
				  {
        			audioElement.pause();
        			audioElement.currentTime = 0;
        			mesero(data.r_id, data.rm_id,'2');
				  }

				})


			}
			else if (data.resultado=='error')
			{

			}

		});

	}, 1000);


});


function mesero(r_id, rm_id, estado)
{	

	var r_id	= r_id;
	var rm_id	= rm_id;
	var estado	= estado;

	$.post("/mod/restaurantes/sql.php", {r_id: r_id, rm_id: rm_id, estado: estado, act: 'mesero_update'},
	function(result)
	{
		if(result=='ok')
		{
			location.reload();
			Dashmix.helpers('jq-notify', {type: 'success', icon: 'fa fa-check me-1', message: 'Su solicitud a sido enviada.'}); 
		}
		else
		{

		}

	});
}

