$(document).ready(function() 
{

	$(window).keydown(function(event)
	{
   	if(event.keyCode == 13) 
		{
      event.preventDefault();
      return false;
    }

	});
	
	
	
class Charts 
{
    
    static initChartsChartJS() 
    {
        // Configuración global de Chart.js
        Chart.defaults.color = "#818d96";
        Chart.defaults.scale.grid.color = "rgba(0,0,0,.04)";
        Chart.defaults.scale.grid.zeroLineColor = "rgba(0,0,0,.1)";
        Chart.defaults.scale.beginAtZero = true;
        Chart.defaults.elements.line.borderWidth = 2;
        Chart.defaults.elements.point.radius = 5;
        Chart.defaults.elements.point.hoverRadius = 7;
        Chart.defaults.plugins.tooltip.radius = 3;
        Chart.defaults.plugins.legend.labels.boxWidth = 12;
        
        var semanal;
        var mensual;
        
        var idchart =   $('#idchart').val();
        
        $.ajax({
            'async': false,
            'type': 'POST',
            'global': false,
            'url': "/mod/reporte_promociones/data.php",
            'dataType': "json",
            'data': {  'idchart': idchart ,'act': 'semanal' },
            'success': function(data) 
            {
                semanal = data;
            }
        });
        
        
        $.ajax({
            'async': false,
            'type': 'POST',
            'global': false,
            'url': "/mod/reporte_promociones/data.php",
            'dataType': "json",
            'data': { 'idchart': idchart ,'act': 'mensual' },
            'success': function(data) {
                mensual = data;
            }
        });
        
        
        console.log(semanal.anterior);
        
        // Datos para los diferentes gráficos
        let semanalData = 
        {
            datasets: [{
                label: "Esta semana",
                fill: true,
                backgroundColor: "rgba(6, 101, 208, .75)",
                borderColor: "rgba(6, 101, 208, 1)",
                pointBackgroundColor: "rgba(6, 101, 208, 1)",
                pointBorderColor: "#fff",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(6, 101, 208, 1)",
                data: semanal.actual
            }]
        };

        // Datos para los diferentes gráficos
        let mensualData = 
        {
            datasets: [{
                label: "Este mes",
                fill: true,
                backgroundColor: "rgba(6, 101, 208, .75)",
                borderColor: "rgba(6, 101, 208, 1)",
                pointBackgroundColor: "rgba(6, 101, 208, 1)",
                pointBorderColor: "#fff",
                pointHoverBackgroundColor: "#fff",
                pointHoverBorderColor: "rgba(6, 101, 208, 1)",
                data: mensual.visitas_mensuales
            }]
        };

        console.log(mensual.visitas_mensuales);

        // Obtener elementos del DOM para los gráficos
        let semanalchart = document.getElementById("semanal");

        // Inicializar gráficos si los elementos existen
        if (semanalchart !== null) 
        {
            new Chart(semanalchart, { type: "line", data: semanalData, options: { tension: 0.4 } });
        }

        // Obtener elementos del DOM para los gráficos
        let mensualchart = document.getElementById("mensual");

        // Inicializar gráficos si los elementos existen
        if (mensualchart !== null) 
        {
            new Chart(mensualchart, { type: "line", data: mensualData, options: { tension: 0.4 } });
        }        
        
    }

    static init() 
    {
        this.initChartsChartJS();
    }
    
}

// Inicializar Dashboard
Charts.init();

});


