$(document).ready(function() 
{

    $("#guardar_informacion").click(function ()
    {
        if($(".formulario").valid())
        {
            guardar_informacion();
        }
                
    });

    $("#editar_informacion").click(function ()
    {

        editar_informacion();
              
    });

    $("#r_id").change(function ()
    {
        $( "#restaurante" ).submit();       
    });


    var today = new Date();
    $("#rr_fecha").flatpickr
    (
        {
            minDate: today,
            disable: ["2022-02-20", "2022-02-21", "2022-03-08", new Date(2025, 4, 9) ],
            dateFormat: "Y-m-d",
        }
    );


    $("#rr_inicio").flatpickr
    (
        {
            enableTime: true,
            time_24hr:false,
            defaultDate: "16:00",
            minTime: "16:00",
            maxTime: "22:00"
        }
    );

    $("#rr_fin").flatpickr
    (
        {
            enableTime: true,
            time_24hr:false,
            defaultDate: "22:00",
            minTime: "16:00",
            maxTime: "22:00"
        }
    );


});


function guardar_informacion()
{

    var r_id        = $('#r_id').val();
    var rr_nombre   = $('#rr_nombre').val();
    var rr_correo   = $('#rr_correo').val();
    var rr_telefono = $('#rr_telefono').val();
    var rr_nota     = $('#rr_nota').val();
    var rr_fecha    = $('#rr_fecha').val();
    var rr_inicio   = $('#rr_inicio').val();
    var rr_fin      = $('#rr_fin').val();
    var rr_color      = $('#rr_color').val();


    $.post("/mod/restaurantes_reservaciones/sql.php", {r_id: r_id, rr_nombre: rr_nombre, rr_correo: rr_correo, rr_telefono: rr_telefono, rr_color: rr_color, rr_nota: rr_nota, rr_fecha: rr_fecha, rr_inicio: rr_inicio, rr_fin: rr_fin, act: 'guardar_informacion'},
    function(result)
    {

        if(result == 'ok')
        {              
            Dashmix.helpers('jq-notify', {type: 'success', icon: 'fa fa-check me-1', message: 'Se ha agregado una reservacion.'});     
            window.location.href = "/menu/restaurantes_reservaciones";
        }
        else
        {
            Dashmix.helpers('jq-notify', {type: 'danger', icon: 'fa fa-times me-1', message: 'Ha ocurrido un error favor, comunicarte con el administrador.'});
        }

    });

}

function editar_informacion()
{

    var rr_id       = $('#rr_idmodal').val();
    var rr_nombre   = $('#rr_nombremodal').val();
    var rr_correo   = $('#rr_correomodal').val();
    var rr_telefono = $('#rr_telefonomodal').val();
    var rr_nota     = $('#rr_notamodal').val();
    var rr_fecha    = $('#rr_fechamodal').val();
    var rr_inicio   = $('#rr_iniciomodal').val();
    var rr_fin      = $('#rr_finmodal').val();
    var rr_color    = $('#rr_colormodal').val();


    $.post("/mod/restaurantes_reservaciones/sql.php", {rr_id : rr_id, rr_nombre: rr_nombre, rr_correo: rr_correo, rr_telefono: rr_telefono, rr_color: rr_color, rr_nota: rr_nota, rr_fecha: rr_fecha, rr_inicio: rr_inicio, rr_fin: rr_fin, act: 'editar_informacion'},
    function(result)
    {
        if(result == 'ok')
        {              
            Dashmix.helpers('jq-notify', {type: 'success', icon: 'fa fa-check me-1', message: 'Se ha modificado una reservacion.'});     
            window.location.href = "/menu/restaurantes_reservaciones";
        }
        else
        {
            Dashmix.helpers('jq-notify', {type: 'danger', icon: 'fa fa-times me-1', message: 'Ha ocurrido un error favor, comunicarte con el administrador.'});
        }

    });

}